### Uses of APIs
-   function that external users call and is a contract on how the function will work
-   helps how to interact with code you have built that customers find valuable
-   Access to data from third parties (see weather app in iPhone, pull lyrics for a song)
-   Hide complexity. Different microservices can scale / develop at their own pace and be efficient
-   Extend functionality. (show widget on iPhone, Alexa API communicating with smart lights)
-   Security keepers (Auth API to validate if user is authenticated)
-   API can be used for client to server comm or server to server comm

### To design an API
To help define your own API program’s value, consider these 5 questions:

1.  **Who is the user?** This question should be answered in terms of their relationship to you (are they existing customers, partners, external developers), their role (are they data scientists, mobile developers, operations people) and their requirements or preferences.
2.  **What user pains are we solving and/or what gains are we creating for the user?** This question should be answered in relationship to the customer’s business, challenges and gains defined by the value proposition, and whether or not a critical need is being fulfilled (is it a pain point, is it a revenue opportunity), and what metric is being improved for the user (speed, revenue, cost saving, being able to do something new).
3.  **Which use cases are supported with your API?** Identify, with the help of the value proposition, the solutions to your user’s challenges or opportunities created by the API that are most effective for your organization and the user. Plan your API to address these use cases. Understand how [[CRUD operations on REST APIs]] work.
4.  **How can the value for the user be expanded over time?** Plan your value proposition with future changes in mind. What are important upcoming milestones relating to internal or external changes?
5.  **What value is being created for your organization internally?** Consider internal benefits and how the API can be of value within the business.
